function [ deltai,ci,ni ] = intsplco( d,delta,c )
%Compute \int^{x}_{delta(1)}s(x)dx antideriv of given spline as a spline.
%   d is the polynomial degree of splines.  delta is the extended knot
%   sequence, and c is row vector giving coefficients of spline on basis.
%   deltai is then the extended knot sequence for the antiderivative
%   spline, and ci are the corresponding coefficients. ni is the dimension
%   of integral spline splace.

%Note Schumaker's book has a typo in the definition of coefficients, so if
%an issue it's probably here under 'Coefficients'
%Dimension
ni = size(delta,2) - d; %n+1 = (n+d+1)-d

%Extended Knot Sequence
deltai = zeros(1,size(delta,2)+2); %n+d+3 = (n+d+1)+2
deltai(1,1) = delta(1,1);                           %Copy the endpoints
deltai(1,size(deltai,2)) = delta(1,size(delta,2));  %over.
for i=2:size(deltai,2)-1
    deltai(1,i) = delta(1,i-1);     %\tilde(y_{i}) = \tilde(y_{i-1})
end

%Coefficients
ci = zeros(1,ni);
for i=2:ni %i=2:ni
    for j=1:i-1 %j=1:i
        ci(1,i) = ci(1,i) + c(1,j)*( (delta(1,d+j+1)-delta(1,j))/(d+1)  );
             %\tilde{c}_{i} = \sum^{i}_{j=1} c_{j}*(y_{d+j-1}-y_{j})/(d+1)
    end
end


end

